/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.Block0Descriptor;

public abstract class MonitorDescriptor
extends Block0Descriptor {
    private int flagReserved_1;
    private int dataTypeTag;
    private int flagReserved_2;
    protected int[] aDescriptorData;
    private int amountPadding;

    public MonitorDescriptor() {
        super(1);
        this.aDescriptorData = new int[13];
    }

    public MonitorDescriptor(int n) {
        super(1);
        this.flagReserved_1 = 0;
        this.flagReserved_2 = 0;
        this.dataTypeTag = n;
        this.aDescriptorData = new int[13];
    }

    public int getTag() {
        return this.dataTypeTag;
    }

    public void setTag(int n) {
        this.dataTypeTag = n;
    }

    public String getDisplayName() {
        String string = null;
        switch (this.dataTypeTag) {
            case 255: {
                string = new String("Monitor Serial Number");
                break;
            }
            case 254: {
                string = new String("ASCII Data String");
                break;
            }
            case 253: {
                string = new String("Monitor Range Limits");
                break;
            }
            case 252: {
                string = new String("Monitor Name");
                break;
            }
            case 250: {
                string = new String("Standard Timing Descriptor");
                break;
            }
            case 16: {
                string = new String("Dummy Descriptor");
                break;
            }
            default: {
                string = new String("Manufacturer Specified");
            }
        }
        return string;
    }

    public String getHeader() {
        String string = new String("0000");
        string = string.concat(String.format("%02X", this.flagReserved_1));
        string = string.concat(String.format("%02X", this.dataTypeTag));
        string = string.concat(String.format("%02X", this.flagReserved_2));
        return string;
    }

    public void setHexData(String string) {
        this.fillDescriptorData(string);
    }

    public String getHexData() {
        return this.getDescriptorData();
    }

    public void setASCIIData(String string) {
        int n;
        int n2 = 0;
        this.amountPadding = this.aDescriptorData.length - string.length();
        n2 = string.length() > this.aDescriptorData.length ? this.aDescriptorData.length : string.length();
        for (n = 0; n < n2; ++n) {
            this.aDescriptorData[n] = string.charAt(n);
        }
        if (this.amountPadding > 0) {
            this.aDescriptorData[n++] = 10;
            while (n < this.aDescriptorData.length) {
                this.aDescriptorData[n] = 32;
                ++n;
            }
        }
    }

    public String getASCIIData() {
        String string = new String();
        int n = this.aDescriptorData.length - this.amountPadding;
        for (int i = 0; i < n; ++i) {
            string = string.concat(String.valueOf((char)this.aDescriptorData[i]));
        }
        return string;
    }

    public String extractDescriptorData() {
        String string = this.getHeader();
        for (int i = 0; i < 13; ++i) {
            string = string.concat(String.format("%02X", this.aDescriptorData[i]));
        }
        return string;
    }

    public void uploadDescriptorData(String string) {
        this.flagReserved_1 = Integer.parseInt(string.substring(4, 6), 16);
        this.dataTypeTag = Integer.parseInt(string.substring(6, 8), 16);
        this.flagReserved_2 = Integer.parseInt(string.substring(8, 10), 16);
        this.fillDescriptorData(string.substring(10, 36));
    }

    private void fillDescriptorData(String string) {
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            this.aDescriptorData[n2] = Integer.parseInt(string.substring(n, n + 2), 16);
            n += 2;
            ++n2;
        }
    }

    private String getDescriptorData() {
        String string = new String();
        for (int i = 0; i < 13; ++i) {
            string = string.concat(Integer.toString(this.aDescriptorData[i]));
        }
        return string;
    }
}

